/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import catserver.server.CatServer;
import catserver.server.launch.Java11Support;
import catserver.server.patcher.IPatcher;
import catserver.server.patcher.PatcherManager;
import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.ReflectionTransformer;
import catserver.server.remapper.RemapRules;
import io.netty.util.internal.ConcurrentSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public final class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new HashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    final JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private LaunchClassLoader launchClassLoader;
    private CatServerRemapper remapper;
    private JarMapping jarMapping;
    private IPatcher patcher;
    private ConcurrentSet<Package> fixedPackages = new ConcurrentSet();

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws IOException, InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.launchClassLoader = parent instanceof LaunchClassLoader ? (LaunchClassLoader)parent : (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        this.jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        provider.add((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        this.jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        this.remapper = new CatServerRemapper(this.jarMapping);
        this.patcher = PatcherManager.getPluginPatcher(description.getName());
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex2) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex2);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex3) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex3);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex4) {
            throw new InvalidPluginException("No public constructor", ex4);
        }
        catch (InstantiationException ex5) {
            throw new InvalidPluginException("Abnormal plugin type", ex5);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (RemapRules.isNMSPackage(name)) {
            String remappedClass = this.jarMapping.classes.getOrDefault(name.replace(".", "/"), name);
            return this.launchClassLoader.findClass(remappedClass);
        }
        if (name.startsWith("org.bukkit.")) {
            throw new ClassNotFoundException(name);
        }
        Class<?> result = this.classes.get(name);
        String string = name.intern();
        synchronized (string) {
            if (result == null) {
                if (checkGlobal) {
                    result = this.loader.getClassByName(name);
                }
                if (result == null && (result = this.remappedFindClass(name)) != null) {
                    this.loader.setClass(name, result);
                }
                if (result == null && checkGlobal) {
                    try {
                        result = this.launchClassLoader.getClass().getClassLoader().loadClass(name);
                    }
                    catch (Throwable throwable) {
                        throw new ClassNotFoundException(name, throwable);
                    }
                }
                if (result == null) {
                    throw new ClassNotFoundException(name);
                }
                this.classes.put(name, result);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block9: {
            result = null;
            try {
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block9;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                URL jarURL = jarURLConnection.getJarFileURL();
                byte[] bytecode = this.remapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                if (this.patcher != null) {
                    bytecode = this.patcher.transform(name.replace("/", "."), bytecode);
                }
                bytecode = ReflectionTransformer.transform(bytecode);
                int dot = name.lastIndexOf(46);
                if (dot != -1) {
                    String pkgName = name.substring(0, dot);
                    Package pkg = this.getPackage(pkgName);
                    if (pkg == null) {
                        try {
                            pkg = this.manifest != null ? this.definePackage(pkgName, this.manifest, url) : this.definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (pkg != null && this.manifest != null) {
                        this.fixPackage(pkg);
                    }
                }
                if ((result = this.defineClass(name, bytecode, 0, bytecode.length, codeSource = new CodeSource(jarURL, new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t) {
                throw new ClassNotFoundException("Failed to remap class " + name, t);
            }
        }
        return result;
    }

    @Override
    protected Package getPackage(String name) {
        if ("org.bukkit.craftbukkit".equals(name)) {
            name = "org.bukkit.craftbukkit." + CatServer.getNativeVersion();
        }
        return super.getPackage(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void fixPackage(Package pkg) {
        block9: {
            if (this.fixedPackages.contains((Object)pkg) || (attr = this.manifest.getMainAttributes()) == null) break block9;
            try {
                if (!Java11Support.enable) ** GOTO lbl-1000
                try {
                    versionInfo = Java11Support.FieldHelper.get(pkg, Package.class.getDeclaredField("versionInfo"));
                    if (versionInfo != null) {
                        classVersionInfo = Class.forName("java.lang.Package$VersionInfo");
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specTitle"), attr.getValue(Attributes.Name.SPECIFICATION_TITLE));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specVersion"), attr.getValue(Attributes.Name.SPECIFICATION_VERSION));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("specVendor"), attr.getValue(Attributes.Name.SPECIFICATION_VENDOR));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implTitle"), attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implVersion"), attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                        Java11Support.FieldHelper.set(versionInfo, classVersionInfo.getDeclaredField("implVendor"), attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                    }
                    return;
                }
                catch (Exception var3_4) {
                    try {
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_TITLE), new String[]{"specTitle"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_VERSION), new String[]{"specVersion"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.SPECIFICATION_VENDOR), new String[]{"specVendor"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE), new String[]{"implTitle"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION), new String[]{"implVersion"});
                        ReflectionHelper.setPrivateValue(Package.class, pkg, attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), new String[]{"implVendor"});
                    }
                    catch (Exception var3_5) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.fixedPackages.add((Object)pkg);
            }
        }
    }

    public PluginDescriptionFile getDescription() {
        return this.description;
    }
}

